/**
* \file: message_sendr.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AMS_IPC_MESSAGE_SENDR_H
#define AMS_IPC_MESSAGE_SENDR_H

#include "utils/automounter_types_internal.h"

#include "ipc/message_buffer.h"

error_code_t message_sendr_init(void);

void message_sendr_deinit(void);

message_buffer_t *message_sendr_get_empty_buffer(void);

void message_sendr_putback_buffer(message_buffer_t *buffer);

error_code_t message_sendr_prepare_message(message_buffer_t *buffer, message_type_t message_type,
		size_t data_size, void **data_buffer);

error_code_t message_sendr_add_string_to_msg(message_buffer_t *buffer, const char *string);

error_code_t message_sendr_send_buffer(message_buffer_t *buffer, int a_socket);

error_code_t message_sendr_clone_msg_in_buffer(message_buffer_t *dst_buffer, message_buffer_t *src_buffer);

void message_sendr_init_message_queue(message_queue_t *queue);

void message_sendr_add_buffer_to_send_queue(message_buffer_t *buffer, message_queue_t *queue);

error_code_t message_sendr_send_queued_buffers(message_queue_t *queue, int a_socket);

void message_sendr_empty_queue(message_queue_t *queue);

#endif
